from bpy.types import Panel
# from ...addon.naming import FluidLabNaming
from ..ui_module_panel import FLUIDLAB_ModulePanel
from ...libs.functions.get_common_vars import get_common_vars
from ...libs.functions.common_ui_elements import title_header

# subsections:
from .ui_emission_adv import emission_adv_ui
from .ui_physics_adv import physics_adv_ui
from .ui_springs_adv import springs_adv_ui
from .ui_animation_adv import animation_adv_ui


class FLUIDLAB_PT_fluid_settings_ui(Panel, FLUIDLAB_ModulePanel):
    fluidlab_section = 'FLUID_SETTINGS'
    bl_idname = "FLUIDLAB_PT_fluid_settings_ui"
    bl_label = "Module"

    def draw(self, context):

        fluidlab, fluid_groups, ui, toggles = get_common_vars(context, get_fluidlab=True, get_fluid_groups=True, get_ui=True, get_toggles=True)

        f_settings = fluidlab.fluid_settings

        emitters_list = None
        active_emitter_item = None

        active_group = fluid_groups.active
        if active_group:
            emitters_list = active_group.emitters
            active_emitter_item = emitters_list.active    
        
        layout = self.layout
        layout.use_property_split = True
        layout.use_property_decorate = False

        col = layout.column(align=True)
        title_header(col, "Fluid Settings")

        main_col = col.box().column(align=True)
        main_col.use_property_split = True
        main_col.use_property_decorate = False

        # -------------------------------------------------------------------------------
        # ## UI BASICA ##
        # ------------------------------------------------------------------------------- 
        if ui.ui_mode == 'BASIC':
            main_col.label(text="Hola Mundo Basico")

    
        # -------------------------------------------------------------------------------
        # ## UI AVANZADA ##
        # ------------------------------------------------------------------------------- 
        elif ui.ui_mode == 'ADVANCED':

            main_col.use_property_split = False
            sections = main_col.grid_flow(row_major=True, even_columns=True, even_rows=True, align=True, columns=2)
            sections.scale_y = 1.3
            sections.prop(f_settings, "fs_sections", expand=True)

            # Sections ui:
            if active_group and active_emitter_item:
                
                # Propiedades de animación a nivel emiter item:
                emission_props = active_emitter_item.emission
                physics_props = active_emitter_item.physics 
                springs_props = active_emitter_item.springs
                anim_physics_props = active_emitter_item.physics.anim
                anim_springs_props = active_emitter_item.springs.anim
                anim_weights_props = active_emitter_item.weights 
                anim_geometry_emitter_props = active_emitter_item.geometry_emitter

                if f_settings.fs_sections == 'EMISSION':
                    # anim_emission_props = active_emitter_item.emission.anim
                    emission_adv_ui(toggles, col, main_col, active_group, emitters_list, active_emitter_item, emission_props)

                elif f_settings.fs_sections == 'PHYSICS':
                    physics_adv_ui(toggles, col, active_emitter_item, physics_props, anim_physics_props, anim_weights_props)
                
                elif f_settings.fs_sections == 'SPRINGS':
                    springs_adv_ui(toggles, col, active_emitter_item, springs_props, anim_springs_props)
                
                elif f_settings.fs_sections == 'ANIMATION':
                    animation_adv_ui(toggles, col, main_col, anim_physics_props, anim_springs_props, anim_weights_props, anim_geometry_emitter_props)